//
//  MCNibLoader.h
//  MCApplication
//
//  Created by Ali Lalani on 8/13/04.
//  Copyright 2004 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MCNibLoader : NSObject {
	// Add generic outlets here for things you want to get from the nib

	IBOutlet NSView *view;
	NSMutableArray *topLevelObjects;
}

+ (id)loaderForNibNamed:(NSString *)aName;
+ (id)loaderForNibNamed:(NSString *)aName bundleIdentifier:(NSString *)ident;
+ (id)loaderForNibNamed:(NSString *)aName bundle:(NSBundle *)aBundle;

- (id)initWithNibNamed:(NSString *)aName bundle:(NSBundle *)aBundle;

- (id)view;

////////////////////// ACCESSORS ////////////////////////
- (NSMutableArray *)topLevelObjects;
- (void)setTopLevelObjects:(NSMutableArray *)aTopLevelObjects;
@end

@protocol MCNibDerivedView <NSObject>
- (void)setTopLevelObjects:(NSArray *)anArray;
- (NSArray *)topLevelObjects;
@end
